function cb_m42
% Menu 42
% Measure impedance

  global Hcal
  global Hcross
  global isCrosstalkComp  
  global f 
  global Rs
  global Cs
  global Ri
  global Ci
  global Rv
  global Rt
  global Ct
  global Cdc
  global rmseZcal
  global isGitLoad
  global sfontsize
  global persParamsDir   
  global puzFname
  global puDataDir
  global m42
  global hdt
  
  capt = get(m42,'label');
  qtext{1}='Is the setup like this:';
  qtext{2}='* MA is connected properly!';
  qtext{3}='* MA switch is set to C!';
  qtext{4}='* Z is connected to impedance port!'; 
  btn = questdlg (qtext, 'Setup Check!','Yes', 'No','No');
  
  if strcmp (btn, 'Yes') 
    
    cancelMeasurement; 
    Haux = measureH;
    measDate=datestr(clock);
    
    if ~isempty(Haux)
      
      s=j*2*pi*f;
      H= Haux./Hcal;
      if isCrosstalkComp
        H = H - Hcross;
      end
      Z= Rs*H./(1-H);
      Z= Z ./ (1+s*Rs*Cs);
      if isGitLoad
         Zp = s*Ci + 1./(Ri + 1./ (s*Cdc)) + 1/Rv + 1./(Rt+ 1./ (s*Ct));          
      else   
         Zp = s*Ci + 1./(Ri + 1./ (s*Cdc)),  
      end
      Zp = 1./ Zp;
      Z=Zp.*Z./(Zp-Z);      
          
      [fname, fpath, fltidx] = uiputfile({'*.puz','Save in a PUZ - file'}, ...
                                        capt,strcat(puDataDir,puzFname));    
      
      if fltidx > 0 
        
        puzFname=fname;
        puDataDir=fpath;
        
        sn = strcat(persParamsDir,'puDirFname.mat');
        save(sn,'puDataDir', 'puzFname'); 
        savename=strcat(puDataDir,puzFname);        
        planename=strrep(puzFname,'.puz','');
        savename2=strcat(puDataDir,planename,'.mzp'); 
        titlename=strcat(planename,': Z / \Omega');
        printname=strcat(puDataDir,planename,' Z.png');        
     
        save('-mat',savename, 'Z');     
        save('-mat',savename2, 'Cs', 'Ci', 'Ri', 'Cdc', 'rmseZcal', ...
                  'Rv', 'Rt' , 'Ct', 'isGitLoad','measDate'); 
                  
        delname =strcat(puDataDir,planename,' ZA.png');
        if exist(delname, 'file') == 2 
            delete(delname)
        end;                  
        delname =strcat(puDataDir,planename,' FR.png');
        if exist(delname, 'file') == 2 
            delete(delname)
        end;
        delname =strcat(puDataDir,planename,'.pup');
        if exist(delname, 'file') == 2 
            delete(delname)
        end;
         
        L=20*log10(abs(Z));
        P=180/pi*angle(Z);  
        
        if ishandle(hdt) 
            delete(hdt) 
        end;
     
        fa=f(1);
        fb=f(end);
        
        subplot(2,1,1)
        
        semilogx(f,L)
        axis([fa fb 55 125])
        grid       
        
        title(titlename); 
        xlabel('Frequency / Hz')
        ylabel('Gain / dB')  
        ha1=gca;         
        
        subplot(2,1,2)
        
        semilogx(f,P)
        axis([fa fb -100 100]);
        grid
        xlabel('Frequency / Hz')
        ylabel('Phase / degree')
        ha2=gca;      
        
        set(gcf,'PaperUnits','inches','PaperPosition',[0 0 9 6]);            
        
        print('-dpng', printname,'-r300');
        
        set(ha1, 'fontsize',sfontsize);   
        set(ha2, 'fontsize',sfontsize); 
        
      end 
      
    end
    
  end 
  
end